' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

''' <summary>
''' Klasa AppConfiguration jest owijk wok ustawie aplikacji w pliku web.config.
''' Eksponuje waciwoci wspdzielone i tylko do odczytu zwracajce ustawienia aplikacji.
''' </summary>
''' <remarks></remarks>
Public Class AppConfiguration
  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia instancji klasy AppConfiguration.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Zwraca maksymaln dozwolon szeroko obrazka w aplikacji.
  ''' </summary>
  Public Shared ReadOnly Property MaxImageWidth() As Integer
    Get
      Return Convert.ToInt32(System.Configuration.ConfigurationManager.AppSettings.Get("MaxImageWidth"))
    End Get
  End Property

  ''' <summary>
  ''' Zwraca maksymaln dozwolon wysoko obrazka w aplikacji.
  ''' </summary>
  Public Shared ReadOnly Property MaxImageHeight() As Integer
    Get
      Return Convert.ToInt32(System.Configuration.ConfigurationManager.AppSettings.Get("MaxImageHeight"))
    End Get
  End Property

  ''' <summary>
  ''' Zwraca ciek wirtualn do folderu gdzie przechowywane bd tymczasowe obrazki.
  ''' </summary>
  ''' <remarks>Wane aby proces serwera www process mia moliwo odczytu i zapisu do tego katalogu.</remarks>
  Public Shared ReadOnly Property TempImagesFolder() As String
    Get
      Return Convert.ToString(System.Configuration.ConfigurationManager.AppSettings.Get("TempImagesFolder"))
    End Get
  End Property

  ''' <summary>
  ''' Zwraca nazw nadawcy uywan w polu From: poczty elektronicznej wysyanej przez aplikacj.
  ''' </summary>
  Public Shared ReadOnly Property EmailFromName() As String
    Get
      Return Convert.ToString(System.Configuration.ConfigurationManager.AppSettings.Get("EmailFromName"))
    End Get
  End Property

  ''' <summary>
  ''' Zwraca adres email uywany w polu From: poczty elektronicznej wysyanej przez aplikacj.
  ''' </summary>
  Public Shared ReadOnly Property EmailFromAddress() As String
    Get
      Return Convert.ToString(System.Configuration.ConfigurationManager.AppSettings.Get("EmailFromAddress"))
    End Get
  End Property

End Class
